<?php
declare(strict_types=1);

// Beklenen değişkenler: $doc, $items, $company, $settings
$slug = tenant_slug();
$id = (int)($doc['id'] ?? 0);

$curSym   = (string)($doc['currency_symbol'] ?? '₺');
$docNo    = trim((string)($doc['doc_no'] ?? 'Fatura'));
$custName = trim((string)($doc['customer_name'] ?? 'Müşteri'));

// 1) "Kargo" kalem olarak var mı? (adı kargo olan ya da içinde kargo geçen satır)
$hasShippingLine = false;
 
foreach (($items ?? []) as $it) {
  if (($it['item_type'] ?? '') === 'shipping') { $hasShippingLine = true; break; }

  // fallback (eski kayıtlar için)
  $raw = trim((string)($it['name'] ?? ''));
  $n = function_exists('mb_strtolower') ? mb_strtolower($raw,'UTF-8') : strtolower($raw);
  if ($n === 'kargo' || str_contains($n, 'kargo')) { $hasShippingLine = true; break; }
}
 

// 2) Kargo ayrı mı tutuluyor? (kalem yoksa kullanılacak)
$shipAmount = (float)($doc['shipping_amount'] ?? 0.0);
$shipVatRate = (float)($settings['shipping_vat_rate'] ?? 20.0);
if ($shipVatRate < 0) $shipVatRate = 0;
if ($shipVatRate > 100) $shipVatRate = 100;

// 3) Kalemlerden doğru toplamları yeniden hesapla (DB’deki subtotal/vat_total/total yanlış olsa bile!)
$calcSubtotal = 0.0;
$calcVatTotal = 0.0;
$calcTotal    = 0.0;

// KDV kırılımı: rateKey => vatAmount
$vatBreakdown = [];

foreach (($items ?? []) as $it) {
  $qty  = (float)($it['qty'] ?? 0);
  $unit = (float)($it['unit_price'] ?? 0);
  $rate = (float)($it['vat_rate'] ?? 0);

  $net = $qty * $unit;
  $vat = $net * ($rate / 100);
  $lineTotal = $net + $vat;

  $calcSubtotal += $net;
  $calcVatTotal += $vat;
  $calcTotal    += $lineTotal;

  $rateKey = number_format($rate, 2, '.', '');
  if (!isset($vatBreakdown[$rateKey])) $vatBreakdown[$rateKey] = 0.0;
  $vatBreakdown[$rateKey] += $vat;
}

// 4) Kargo kalem olarak YOKSA ve shipping_amount varsa → onu da toplam ve KDV kırılımına ekle
if (!$hasShippingLine && $shipAmount > 0) {
  $shipVat = ($shipVatRate > 0) ? ($shipAmount * ($shipVatRate / 100)) : 0.0;
  $calcSubtotal += $shipAmount;
  $calcVatTotal += $shipVat;
  $calcTotal    += ($shipAmount + $shipVat);

  if ($shipVatRate > 0) {
    $rateKey = number_format($shipVatRate, 2, '.', '');
    if (!isset($vatBreakdown[$rateKey])) $vatBreakdown[$rateKey] = 0.0;
    $vatBreakdown[$rateKey] += $shipVat;
  }
}

// Oranları küçükten büyüğe sırala
ksort($vatBreakdown, SORT_NUMERIC);
?>
<style>
/* Ekranda daha derli toplu */
.print-wrap{ max-width: 920px; margin: 0 auto; }

/* Yazdırırken SADECE .print-area görünsün + kenarlarda boşluk olsun */
@media print {
  @page { margin: 12mm; }
  html, body { background:#fff !important; }
  body { -webkit-print-color-adjust: exact; print-color-adjust: exact; }

  body * { visibility: hidden !important; }
  .print-area, .print-area * { visibility: visible !important; }

  .print-area {
    position: absolute !important;
    left: 0 !important;
    top: 0 !important;
    width: 100% !important;
  }

  .no-print { display: none !important; }

  .print-card {
    border: none !important;
    box-shadow: none !important;
    padding: 0 !important;
  }
}
</style>

<script>
  // PDF dosya adını güzel öner
  document.title = <?= json_encode($docNo . ' - ' . $custName, JSON_UNESCAPED_UNICODE) ?>;
</script>

<!-- ÜST AKSİYONLAR (ekranda var, yazdırmada yok) -->
<div class="no-print flex items-center justify-between gap-2">
  <div>
    <h2 class="text-lg font-semibold">Yazdır: <?= e($docNo) ?></h2>
    <div class="mt-1 text-sm text-slate-500 dark:text-slate-400">
      PDF için yazdır penceresinden “PDF olarak kaydet”.
    </div>
  </div>
  <div class="flex gap-2">
    <a href="<?= e(base_path('/'.$slug.'/invoices/view?id='.$id)) ?>"
       class="rounded-xl border border-slate-200 px-4 py-2 text-sm hover:bg-slate-50 dark:border-slate-800 dark:hover:bg-slate-900/50">← Geri</a>
    <button type="button" onclick="window.print()"
       class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">Yazdır</button>
  </div>
</div>

<div class="print-area mt-6">
  <div class="print-wrap">
    <div class="print-card rounded-2xl border border-slate-200 p-6 dark:border-slate-800">

      <div class="flex items-start justify-between gap-4">
        <div class="flex items-start gap-4">
<?php
  $logo = (string)($company['logo_url'] ?? $company['logo_path'] ?? '');

  // normalize: relative ise site köküne çevir
  if ($logo && !preg_match('~^https?://~i', $logo)) {
    // "/uploads/..." değilse başına "/" koy
    if ($logo[0] !== '/') $logo = '/'.$logo;
    $logo = base_path($logo);
  }
?>
<?php if ($logo): ?>
  <img src="<?= e($logo) ?>" alt="Logo" class="h-14 w-auto object-contain">
<?php endif; ?>


          <div>
            <div class="text-sm text-slate-500 dark:text-slate-400">Firma</div>
            <div class="text-xl font-bold"><?= e((string)($company['name'] ?? '')) ?></div>

            <div class="mt-2 text-sm text-slate-600 dark:text-slate-300 space-y-1">
              <?php if (!empty($company['address'])): ?><div class="whitespace-pre-line"><?= e((string)$company['address']) ?></div><?php endif; ?>
              <?php if (!empty($company['tax_office']) || !empty($company['tax_no'])): ?>
                <div>Vergi: <?= e((string)($company['tax_office'] ?? '')) ?><?= !empty($company['tax_no']) ? ' • '.e((string)$company['tax_no']) : '' ?></div>
              <?php endif; ?>
              <?php if (!empty($company['phone'])): ?><div>Tel: <?= e((string)$company['phone']) ?></div><?php endif; ?>
              <?php if (!empty($company['email'])): ?><div>E-posta: <?= e((string)$company['email']) ?></div><?php endif; ?>
              <?php if (!empty($company['website'])): ?><div>Web: <?= e((string)$company['website']) ?></div><?php endif; ?>
              <?php if (!empty($company['iban'])): ?><div>IBAN: <?= e((string)$company['iban']) ?></div><?php endif; ?>
            </div>
          </div>
        </div>

        <div class="text-right">
          <div class="text-sm text-slate-500 dark:text-slate-400">Fatura No</div>
          <div class="text-lg font-semibold"><?= e($docNo) ?></div>
          <div class="mt-1 text-sm text-slate-500 dark:text-slate-400">Tarih: <?= e((string)($doc['issue_date'] ?? '')) ?></div>
          <?php if (!empty($doc['due_date'])): ?>
            <div class="text-sm text-slate-500 dark:text-slate-400">Vade: <?= e((string)$doc['due_date']) ?></div>
          <?php endif; ?>
        </div>
      </div>

      <div class="mt-6 grid grid-cols-1 gap-4 md:grid-cols-2">
        <div class="rounded-xl border border-slate-200 p-4 dark:border-slate-800">
          <div class="text-xs text-slate-500 dark:text-slate-400">Müşteri</div>
          <div class="mt-1 font-semibold"><?= e($custName) ?></div>
          <div class="mt-2 space-y-1 text-sm text-slate-600 dark:text-slate-300">
            <?php if (!empty($doc['customer_email'])): ?><div><?= e((string)$doc['customer_email']) ?></div><?php endif; ?>
            <?php if (!empty($doc['customer_phone'])): ?><div><?= e((string)$doc['customer_phone']) ?></div><?php endif; ?>
            <?php if (!empty($doc['customer_address'])): ?><div class="whitespace-pre-line"><?= e((string)$doc['customer_address']) ?></div><?php endif; ?>
          </div>
        </div>

        <div class="rounded-xl border border-slate-200 p-4 dark:border-slate-800">
          <div class="text-xs text-slate-500 dark:text-slate-400">Özet</div>

          <div class="mt-3 space-y-2 text-sm">
            <div class="flex justify-between">
              <span class="text-slate-500 dark:text-slate-400">Ara toplam</span>
              <span class="font-semibold"><?= e($curSym) ?> <?= number_format($calcSubtotal,2,',','.') ?></span>
            </div>

            <div class="flex justify-between">
              <span class="text-slate-500 dark:text-slate-400">KDV</span>
              <span class="font-semibold"><?= e($curSym) ?> <?= number_format($calcVatTotal,2,',','.') ?></span>
            </div>

            <?php if (!empty($vatBreakdown)): ?>
              <div class="mt-2 rounded-lg border border-slate-200 bg-white px-3 py-2 text-xs dark:border-slate-800 dark:bg-transparent">
                <div class="font-semibold text-slate-700 dark:text-slate-200">KDV Kırılımı</div>
                <div class="mt-1 space-y-1">
                  <?php foreach ($vatBreakdown as $rateKey => $vatAmt): ?>
                    <?php if (abs($vatAmt) < 0.005) continue; ?>
                    <div class="flex justify-between">
                      <span class="text-slate-500 dark:text-slate-400">%<?= e(rtrim(rtrim($rateKey,'0'),'.')) ?> KDV</span>
                      <span class="font-semibold"><?= e($curSym) ?> <?= number_format((float)$vatAmt, 2, ',', '.') ?></span>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endif; ?>

            <?php
              // Özet kargo satırı: SADECE kalem olarak yoksa ve shipping_amount varsa
              if (!$hasShippingLine && $shipAmount > 0):
            ?>
              <div class="flex justify-between">
                <span class="text-slate-500 dark:text-slate-400">Kargo</span>
                <span class="font-semibold"><?= e($curSym) ?> <?= number_format($shipAmount,2,',','.') ?></span>
              </div>
              <div class="text-xs text-slate-500 dark:text-slate-400">Kargo KDV oranı: %<?= e(rtrim(rtrim(number_format($shipVatRate,2,'.',''),'0'),'.')) ?></div>
            <?php endif; ?>

            <div class="mt-2 flex justify-between rounded-lg bg-slate-50 px-3 py-2 dark:bg-slate-950/40">
              <span class="text-slate-700 dark:text-slate-200">Genel toplam</span>
              <span class="text-base font-bold"><?= e($curSym) ?> <?= number_format($calcTotal,2,',','.') ?></span>
            </div>
          </div>
        </div>
      </div>

      <div class="mt-6 overflow-auto rounded-xl border border-slate-200 dark:border-slate-800">
        <table class="min-w-full text-sm">
          <thead class="text-left text-xs text-slate-500 dark:text-slate-400">
            <tr>
              <th class="px-4 py-3">Ürün/Hizmet</th>
              <th class="px-4 py-3">Açıklama</th>
              <th class="px-4 py-3">Miktar</th>
              <th class="px-4 py-3">Birim</th>
              <th class="px-4 py-3">Birim Fiyat</th>
              <th class="px-4 py-3">KDV %</th>
              <th class="px-4 py-3 text-right">Tutar</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-slate-100 dark:divide-slate-800">
            <?php foreach (($items ?? []) as $it): ?>
              <?php
                $qty  = (float)($it['qty'] ?? 0);
                $unit = (float)($it['unit_price'] ?? 0);
                $rate = (float)($it['vat_rate'] ?? 0);

                $net = $qty * $unit;
                $vat = $net * ($rate / 100);
                $lineTotal = $net + $vat;
              ?>
              <tr>
                <td class="px-4 py-3 font-medium"><?= e((string)$it['name']) ?></td>
                <td class="px-4 py-3 text-slate-600 dark:text-slate-300"><?= e((string)($it['description'] ?? '')) ?></td>
                <td class="px-4 py-3"><?= rtrim(rtrim(number_format($qty,3,',','.'),'0'),',') ?></td>
                <td class="px-4 py-3"><?= e((string)($it['unit'] ?? '')) ?></td>
                <td class="px-4 py-3"><?= e($curSym) ?> <?= number_format($unit,2,',','.') ?></td>
                <td class="px-4 py-3"><?= number_format($rate,2,',','.') ?></td>
                <td class="px-4 py-3 text-right font-semibold"><?= e($curSym) ?> <?= number_format($lineTotal,2,',','.') ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>

      <?php if (!empty($doc['notes'])): ?>
        <div class="mt-6 rounded-xl border border-slate-200 p-4 dark:border-slate-800">
          <div class="text-xs text-slate-500 dark:text-slate-400">Notlar</div>
          <div class="mt-1 whitespace-pre-line text-sm"><?= e((string)$doc['notes']) ?></div>
        </div>
      <?php endif; ?>

      <div class="mt-6 text-xs text-slate-500 dark:text-slate-400">
        Bu belge sistem üzerinden oluşturulmuştur.
      </div>

    </div>
  </div>
</div>
